/**************************************************************************
 *
 *  BRIEF MODULE DESCRIPTION
 *     DS1553(Dallas Semiconductor) Real Time Clock and Non-Volatile RAM.
 *
 *  Copyright 2004 IDT Inc. (rischelp@idt.com)
 *         
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 **************************************************************************
 * P. Sadik       Oct 07,2003
 * Ported from IdtBoot
 **************************************************************************
 */

#ifndef _DS1553RTC_H_
#define _DS1553RTC_H_

#define RTC_BASE           0xAC080000
/*
 * To maintain endianess independence, make all accesses as 32-bit
 * words with appropriate shifting.
 */
#define TD_NVRAM_SIZE 0x1FF0

typedef struct td_clock {
  unsigned char ram[TD_NVRAM_SIZE];
  unsigned char flags;
  unsigned char dummy;
  unsigned char alarm_secs;
  unsigned char alarm_mins;
  unsigned char alarm_hours;
  unsigned char alarm_date;
  unsigned char interrupts;
  unsigned char watchdog;
  unsigned char control;
  unsigned char secs;
  unsigned char mins;
  unsigned char hours;
  unsigned char weekday;
  unsigned char date;
  unsigned char month;
  unsigned char year;
} RTC;

#define rtc ((volatile RTC *)RTC_BASE)

/*
 * Control register bit definitions
 */
#define TDC_ENA_WRITE   0x80
#define TDC_DIS_WRITE   0x7f
#define TDC_ENA_READ    0x40
#define TDC_DIS_READ    0xBf
#define TDS_STOP    	0x80

#endif /* _DS1553RTC_H */

