/**************************************************************************
 *
 *  BRIEF MODULE DESCRIPTION
 *      EB438 specific pci accesses.
 *
 *  Copyright 2004 IDT Inc. (rischelp@idt.com)
 *         
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 **************************************************************************
 */

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/proc_fs.h>
#include <linux/sched.h>
#include <asm/uaccess.h>
#include <linux/string.h>
#include <asm/rc32438/dma_v.h>

static volatile struct DMAD_s desc_read;
static volatile struct DMAD_s desc_write;
static volatile DMAD_t desc_r;
static volatile DMAD_t desc_w;
static volatile unsigned int data, *pdata;
static volatile DMA_Chan_t  rc32438_pci_dma_regs_r;
static volatile DMA_Chan_t  rc32438_pci_dma_regs_w;

extern unsigned char rc32438_pci_inb(unsigned long addr)
{
  
  desc_r->control = 0x01c00001;
  desc_r->devcs = addr;
  desc_r->ca = virt_to_phys(&data);
  desc_r->link = 0;
  *pdata = 0;

  local_writel(0, &rc32438_pci_dma_regs_r->dmas);
  rc32438_start_dma(rc32438_pci_dma_regs_r, virt_to_phys(desc_r));

  while (!local_readl(&rc32438_pci_dma_regs_r->dmas));

#if defined(__MIPSEB__)
  printk("B\n");
  return (unsigned char)(*pdata >> 24);
#else
  printk("L\n");
  return (unsigned char)(*pdata);
#endif
}

extern int rc32438_pci_outb(unsigned char val, unsigned long addr)
{

#if defined(__MIPSEB__)
  *pdata = val << 24;
#else
  *pdata = val;
#endif
  desc_w->control = 0x01c00001;	
  desc_w->devcs = addr;
  desc_w->ca = virt_to_phys(&data);
  desc_w->link = 0;
  
  local_writel(0, &rc32438_pci_dma_regs_w->dmas);
  rc32438_start_dma(rc32438_pci_dma_regs_w, virt_to_phys(desc_w));
  
  while (!local_readl(&rc32438_pci_dma_regs_w->dmas));
  
  SLOW_DOWN_IO;
  return 0;
}

int __init rc32438_pci_dma_init(void)
{
  rc32438_pci_dma_regs_r =ioremap_nocache(DMA0_PhysicalAddress + DMACH_pciToMem * DMA_CHAN_OFFSET, sizeof(struct DMA_Chan_s));
  if(!rc32438_pci_dma_regs_r)
    {
      printk("Cannot map rc32438_pci_dma_regs_r\n");
      return -1;
    }
  rc32438_pci_dma_regs_w =ioremap_nocache(DMA0_PhysicalAddress + DMACH_memToPci * DMA_CHAN_OFFSET, sizeof(struct DMA_Chan_s));

  if(!rc32438_pci_dma_regs_w)
    {
      printk("Cannot map rc32438_pci_dma_regs_w\n");
      iounmap((void *)rc32438_pci_dma_regs_r);
      return -1;
    }
/*  desc_r  = (DMAD_t)&desc_read;
  desc_w  = (DMAD_t)&desc_write;
  pdata   = (unsigned int *)&data;
*/
  desc_r  = (DMAD_t)KSEG1ADDR(&desc_read);
  desc_w  = (DMAD_t)KSEG1ADDR(&desc_write);
  pdata   = (unsigned int *)KSEG1ADDR(&data);

  return 0;
}

void __exit rc32438_pci_dma_exit(void)
{
  iounmap((void *)rc32438_pci_dma_regs_r);
  iounmap((void *)rc32438_pci_dma_regs_w);

  return;
}
