/**************************************************************************
 *
 *  BRIEF MODULE DESCRIPTION
 *	EB438 specific pci support.
 *
 *  Copyright 2004 IDT Inc. (rischelp@idt.com)
 *         
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 **************************************************************************
 * Copyright 2001 MontaVista Software Inc.
 * Author: MontaVista Software, Inc.
 *              stevel@mvista.com or source@mvista.com
 **************************************************************************
 */

#include <linux/config.h>

#ifdef CONFIG_PCI

#include <linux/types.h>
#include <linux/pci.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <asm/pci_channel.h>
#include <asm/rc32438/rc32438.h>
#include <asm/rc32438/pci.h> 
#include <asm/rc32438/pciacacia.h> 

#define PCI_ACCESS_READ  0
#define PCI_ACCESS_WRITE 1

#undef DEBUG
#ifdef DEBUG
#define DBG(x...) printk(x)
#else
#define DBG(x...)
#endif

#ifdef __MIPSEB__
#define SWAP_BIT 1
#else
#define SWAP_BIT 0
#endif
/* define an unsigned array for the PCI registers */
unsigned int acaciaCnfgRegs[25] = {
				ACACIA_CNFG1,
				ACACIA_CNFG2,
				ACACIA_CNFG3,
				ACACIA_CNFG4,	
				ACACIA_CNFG5,
				ACACIA_CNFG6,
				ACACIA_CNFG7,
				ACACIA_CNFG8,
				ACACIA_CNFG9,
				ACACIA_CNFG10,
				ACACIA_CNFG11,
				ACACIA_CNFG12,
				ACACIA_CNFG13,
				ACACIA_CNFG14,
				ACACIA_CNFG15,
				ACACIA_CNFG16,
				ACACIA_CNFG17,
				ACACIA_CNFG18,
				ACACIA_CNFG19,
				ACACIA_CNFG20,
				ACACIA_CNFG21,				
				ACACIA_CNFG22,
				ACACIA_CNFG23,
				ACACIA_CNFG24};
unsigned int pciConfigAddr;/*used for writing pci config values */
int	     loopCount    ;/*used for the loop */
unsigned int dummyRead    ;/*used to flush CPU write buffers */
extern struct resource rc32438_res_pci_io1;
extern struct resource rc32438_res_pci_io2;
extern struct resource rc32438_res_pci_mem1;
extern struct resource rc32438_res_pci_mem2;

extern char * __init prom_getcmdline(void);

#define PCI_CFG_SET(slot,func,off) \
	(rc32438_pci->pcicfga = (0x80000000 | ((slot)<<11) | \
			    ((func)<<8) | (off)))

static int
config_access(u8 type, u8 bus, u8 devfn, u8 where, u32 *data)
{
	/* 
	 * config cycles are on 4 byte boundary only
	 */
	u8 slot = PCI_SLOT(devfn);
	u8 func = PCI_FUNC(devfn);
	
	if (bus != 0 || slot > 5) {
		*data = 0xFFFFFFFF;
		return PCIBIOS_DEVICE_NOT_FOUND;
	}

	/* Setup address */
	PCI_CFG_SET(slot, func, where);
	rc32438_sync();

	if (type == PCI_ACCESS_WRITE)
	        rc32438_pci->pcicfgd = *data;

	else
		*data = rc32438_pci->pcicfgd;
	rc32438_sync();

	/*
	 * Revisit: check for master or target abort.
	 */
	return 0;
}

static inline int config_write(u8 bus, u8 devfn, u8 where, u32 data)
{
	return config_access(PCI_ACCESS_WRITE, bus, devfn, where, &data);
}

static inline int config_read(u8 bus, u8 devfn, u8 where, u32 *data)
{
	return config_access(PCI_ACCESS_READ, bus, devfn, where, data);
}

/*
 * We can't address 8 and 16 bit words directly.  Instead we have to
 * read/write a 32bit word and mask/modify the data we actually want.
 */
static int
read_config_byte (struct pci_dev *dev, int where, u8 *val)
{
	u32 data = 0;

	if (config_read(dev->bus->number, dev->devfn, where, &data))
		return -1;

	*val = (data >> ((where & 3) << 3)) & 0xff;
        DBG("cfg read byte: bus %d dev_fn %x where %x: val %x\n", 
                dev->bus->number, dev->devfn, where, *val);

	return PCIBIOS_SUCCESSFUL;
}


static int
read_config_word (struct pci_dev *dev, int where, u16 *val)
{
	u32 data = 0;

	if (where & 1)
		return PCIBIOS_BAD_REGISTER_NUMBER;

	if (config_read(dev->bus->number, dev->devfn, where, &data))
		return -1;

	*val = (data >> ((where & 3) << 3)) & 0xffff;
        DBG("cfg read word: bus %d dev_fn %x where %x: val %x\n", 
                dev->bus->number, dev->devfn, where, *val);

	return PCIBIOS_SUCCESSFUL;
}

static int
read_config_dword (struct pci_dev *dev, int where, u32 *val)
{
	u32 data = 0;

	if (where & 3)
		return PCIBIOS_BAD_REGISTER_NUMBER;
	
	if (config_read(dev->bus->number, dev->devfn, where, &data))
		return -1;

	*val = data;
        DBG("cfg read dword: bus %d dev_fn %x where %x: val %x\n", 
                dev->bus->number, dev->devfn, where, *val);

	return PCIBIOS_SUCCESSFUL;
}


static int
write_config_byte (struct pci_dev *dev, int where, u8 val)
{
	u32 data = 0;
       
	if (config_read(dev->bus->number, dev->devfn, where, &data))
		return -1;

	data = (data & ~(0xff << ((where & 3) << 3))) |
	       (val << ((where & 3) << 3));

	if (config_write(dev->bus->number, dev->devfn, where, data))
		return -1;

	return PCIBIOS_SUCCESSFUL;
}

static int
write_config_word (struct pci_dev *dev, int where, u16 val)
{
        u32 data = 0;

	if (where & 1)
		return PCIBIOS_BAD_REGISTER_NUMBER;
       
        if (config_read(dev->bus->number, dev->devfn, where, &data))
		return -1;

	data = (data & ~(0xffff << ((where & 3) << 3))) | 
	       (val << ((where & 3) << 3));

	if (config_write(dev->bus->number, dev->devfn, where, data))
	       return -1;

	return PCIBIOS_SUCCESSFUL;
}

static int
write_config_dword(struct pci_dev *dev, int where, u32 val)
{
	if (where & 3)
		return PCIBIOS_BAD_REGISTER_NUMBER;

	if (config_write(dev->bus->number, dev->devfn, where, val))
		return -1;

	return PCIBIOS_SUCCESSFUL;
}

static struct pci_ops rc32438_pci_ops = {
	read_config_byte,
        read_config_word,
	read_config_dword,
	write_config_byte,
	write_config_word,
	write_config_dword
};

struct pci_channel mips_pci_channels[] = {
	{ &rc32438_pci_ops, &rc32438_res_pci_io1,
	  &rc32438_res_pci_mem1, PCI_DEVFN(1,0), PCI_DEVFN(6,0) },
	{ NULL, NULL, NULL, 0, 0}
};

unsigned __init int pcibios_assign_all_busses(void)
{
       return 1;
}


static void rc32438_dump_pci_bridge(void)
{
	int i;
	u32 val;
	printk("RC32438 PCI Bridge Config:\n");

	printk("PCI_MEM1_BASE: 0x%08x\n", rc32438_pci->pcilba[0].a);
	printk("PCI_IO1_BASE: 0x%08x\n", rc32438_pci->pcilba[1].a);
	printk("PCI_MEM2_BASE: 0x%08x\n", rc32438_pci->pcilba[2].a);
	printk("PCI_IO2_BASE:  0x%08x\n", rc32438_pci->pcilba[3].a);

	for (i=0; i<17; i++) {
		config_read(0, 0, i*4, &val);
		printk("dword %d\t%08x\n", i, val);
	}
}

void __init rc32438_pcibridge_init(void)
{

	unsigned int pcicValue, pcicData=0;
        unsigned int dummyRead, pciCntlVal;
	printk("PCI: Initializing PCI\n");
        pcicValue = rc32438_pci->pcic;
	pcicValue = (pcicValue >> PCIM_SHFT) & PCIM_BIT_LEN;
        if (!((pcicValue == PCIM_H_EA) ||
	     (pcicValue == PCIM_H_IA_FIX) ||
		(pcicValue == PCIM_H_IA_RR))) {
		/* Not in Host Mode, return ERROR */
		return;
	}

        /* Enables the Idle Grant mode, Arbiter Parking */
	pcicData |=(PCIC_igm_m|PCIC_eap_m|PCIC_en_m);
        rc32438_pci->pcic = pcicData; /* Enable the PCI bus Interface */
	/* Zero out the PCI status & PCI Status Mask */
        for(;;)
        {
	   pcicData = rc32438_pci->pcis;
           if (!(pcicData & PCIS_rip_m))
                break;
        }

	rc32438_pci->pcis = 0;
        rc32438_pci->pcism = 0xFFFFFFFF;
	/* Zero out the PCI decoupled registers */
	rc32438_pci->pcidac=0; /* disable PCI decoupled accesses at initialization */
	rc32438_pci->pcidas=0; /* clear the status */
	rc32438_pci->pcidasm=0x0000007F; /* Mask all the interrupts */
	/* Mask PCI Messaging Interrupts */
	rc32438_pci_msg->pciiic = 0;
	rc32438_pci_msg->pciiim = 0xFFFFFFFF;
	rc32438_pci_msg->pciioic = 0;
	rc32438_pci_msg->pciioim = 0;


        /* Setup PCILB0 as Memory Window */
	rc32438_pci->pcilba[0].a = (unsigned int) (PCI_ADDR_START);

	/* setup the PCI map address as same as the local address */

	rc32438_pci->pcilba[0].m = (unsigned int) (PCI_ADDR_START);

	/* Setup PCILBA1 as MEM */
#ifdef __MIPSEB__
	        rc32438_pci->pcilba[0].c = ( ((SIZE_128MB & 0x1f) << PCILBAC_size_b) | PCILBAC_sb_m);
#else
	        rc32438_pci->pcilba[0].c = ( ((SIZE_128MB & 0x1f) << PCILBAC_size_b));
#endif
	dummyRead = rc32438_pci->pcilba[0].c; /* flush the CPU write Buffers */

	rc32438_pci->pcilba[1].a = 0x60000000;
    
	rc32438_pci->pcilba[1].m = 0x60000000;
        /* setup PCILBA2 as IO Window*/
#ifdef __MIPSEB__
	rc32438_pci->pcilba[1].c = ( ((SIZE_1MB & 0x1f) << PCILBAC_size_b) |  PCILBAC_sb_m);
#else
	rc32438_pci->pcilba[1].c = ((SIZE_1MB & 0x1f) << PCILBAC_size_b);
#endif
  
	dummyRead = rc32438_pci->pcilba[1].c; /* flush the CPU write Buffers */
	rc32438_pci->pcilba[2].a = 0;//x18C00000;
    
	rc32438_pci->pcilba[2].m = 0;//x18FFFFFF;
        /* setup PCILBA2 as IO Window*/
#ifdef __MIPSEB__
	rc32438_pci->pcilba[2].c = 0;//( ((SIZE_4MB & 0x1f) << PCILBAC_size_b)  |  PCILBAC_sb_m);
#else
	rc32438_pci->pcilba[2].c = 0;//((SIZE_4MB & 0x1f) << PCILBAC_size_b);
#endif  
  
	dummyRead = rc32438_pci->pcilba[2].c; /* flush the CPU write Buffers */


	rc32438_pci->pcilba[3].a = 0x18800000;

	rc32438_pci->pcilba[3].m = 0x18800000;
	/* Setup PCILBA3 as IO Window */

#ifdef __MIPSEB__
	rc32438_pci->pcilba[3].c = ( (((SIZE_1MB & 0x1ff) << PCILBAC_size_b) | PCILBAC_msi_m)   |  PCILBAC_sb_m);
#else
	rc32438_pci->pcilba[3].c = (((SIZE_1MB & 0x1ff) << PCILBAC_size_b) | PCILBAC_msi_m);
#endif
	dummyRead = rc32438_pci->pcilba[2].c; /* flush the CPU write Buffers */

	pciConfigAddr=(unsigned int)(0x80000004);
	for(loopCount=0;loopCount<24;loopCount++){
		rc32438_pci->pcicfga=pciConfigAddr;
		dummyRead=rc32438_pci->pcicfga;
		rc32438_pci->pcicfgd = acaciaCnfgRegs[loopCount];
		dummyRead=rc32438_pci->pcicfgd;
		pciConfigAddr += 4;
	}
	rc32438_pci->pcitc=(unsigned int)((PCITC_RTIMER_VAL&0xff) << PCITC_rtimer_b) |
 \
				((PCITC_DTIMER_VAL&0xff)<<PCITC_dtimer_b);

	pciCntlVal=rc32438_pci->pcic;
	pciCntlVal &=~(PCIC_tnr_m);
	rc32438_pci->pcic = pciCntlVal;
	pciCntlVal=rc32438_pci->pcic;

#ifdef __MIPSEB__
#define ENDIANNESS_BIT 1
#else
#define ENDIANNESS_BIT 0
#endif
	rc32438_sync();   
}

#endif /* CONFIG_PCI */












