/**************************************************************************
 *
 *  BRIEF MODULE DESCRIPTION
 *     prom interface routines
 *
 *  Copyright 2004 IDT Inc. (rischelp@idt.com)
 *         
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 **************************************************************************
 * P . Sadik Oct 10, 2003
 *
 * Started change log
 * idt_cpu_freq is made a kernel configuration parameter
 * idt_cpu_freq is exported so that other modules can use it.
 * Code cleanup* P . Sadik Oct 10, 2003
 *
 * Started change log
 * idt_cpu_freq is made a kernel configuration parameter
 * idt_cpu_freq is exported so that other modules can use it.
 * Code cleanup
 **************************************************************************
 * P . Sadik Oct 20, 2003
 *
 * Removed NVRAM code from here, since they are already available under
 * nvram directory.
 * Added serial port initialisation.
 **************************************************************************
 * P . Sadik Oct 30, 2003
 *
 * Added   reset_cons_port
 **************************************************************************
 */

#include <linux/config.h>
#include <linux/init.h>
#include <linux/mm.h>
#include <linux/module.h>
#include <linux/string.h>
#include <linux/console.h>
#include <asm/bootinfo.h>
#include <linux/bootmem.h>
#include <linux/ioport.h>
#include <linux/serial.h>
#include <linux/serialP.h>
#include <asm/serial.h>
#include <linux/ioport.h>
char arcs_cmdline[COMMAND_LINE_SIZE];

#define PROM_ENTRY(x)   (0xbfc00000+((x)*8))
extern void cons_putc(char c);
extern void cons_puts(char *s);

void (*prom_puts)(char *str) = cons_puts;
void (*prom_putchar)(char c) = cons_putc;
int (*prom_getchar)(void) = (int (*)(void))PROM_ENTRY(11);

unsigned int idt_cpu_freq = CONFIG_IDT_BOARD_FREQ;
EXPORT_SYMBOL(idt_cpu_freq);

#ifdef CONFIG_REMOTE_DEBUG
extern int remote_debug;
#endif
extern void setup_serial_port(void);
#ifdef CONFIG_IDT_BOOT_NVRAM
extern void mapenv(int (*func)(char *, char *));
static int make_bootparm(char *name,char *val)
{ 
/*
 * The bootparameters are obtained from NVRAM and formatted here.
 * For e.g.
 *
 *    netaddr=10.0.1.95
 *    bootaddr=10.0.0.139
 *    bootfile=vmlinus
 *    bootparm1=root=/dev/nfs
 *    bootparm2=ip=10.0.1.95
 *
 * is parsed to:
 *
 *      root=/dev/nfs ip=10.0.1.95
 *
 * in arcs_cmdline[].
 */
  if (strncmp(name, "bootparm", 8) == 0) {
    strcat(arcs_cmdline,val);
    strcat(arcs_cmdline," ");
  }
  else if(strncmp(name, "HZ", 2) == 0) {
    idt_cpu_freq = simple_strtoul(val, 0, 10);
    printk("CPU Clock at %d Hz (from HZ environment variable)\n",
           idt_cpu_freq);
  }
  return 0;
}
static void prom_init_cmdline(void)
{ 
  memset(arcs_cmdline,0,sizeof(arcs_cmdline));
  mapenv(&make_bootparm);
}
#else
/* Kernel Boot parameters */
static unsigned char bootparm[]="ip=157.165.29.36:157.165.29.18::255.255.0.0::eth0";
#endif

void prom_console_write(struct console *con, const char *s, unsigned count)
{
	int i;

	for(i = 0; i < count; i++, s++) {
		if(*s == '\n') prom_putchar('\r');
		prom_putchar(*s);
	}
}

kdev_t prom_console_device(struct console *con)
{
	return MKDEV(TTY_MAJOR, 64 + con->index);
}

int prom_console_wait_key(struct console *con)
{
	return prom_getchar();
}

int prom_console_setup(struct console *con, char *options)
{
  reset_cons_port();
  return 0;
}

struct console prom_console_driver = {
	"ttyS",
	prom_console_write,		/* write */
	NULL,				/* read */
	prom_console_device,		/* device */
	//prom_console_wait_key,		/* wait_key */
	NULL,				/* unblank */
	prom_console_setup,   		/* setup */
	CON_PRINTBUFFER,
	-1,
	0,
	NULL
};

extern unsigned long mips_machgroup;
extern unsigned long mips_machtype;

/* IDT 79EB438 memory map -- we really should be auto sizing it */

#define RAM_FIRST       0x80000400  /* Leave room for interrupt vectors */
#define RAM_SIZE        64*1024*1024
#define RAM_END         (0x80000000 + RAM_SIZE)     
struct resource rc32438_res_ram = {
	"RAM",
	0,
	RAM_SIZE,
	IORESOURCE_MEM
};

int __init prom_init(int argc, char **argv, char **envp)
{
#ifdef CONFIG_IDT_BOOT_NVRAM
	/* set up command line */
	prom_init_cmdline();
#else
    int i;
    for (i=0; i<argc; i++) {
        strcat(arcs_cmdline, " ");
        strcat(arcs_cmdline, argv[i]);
    }
#endif

	/* turn on the console */

#define CONFIG_IDT_PROM_CONSOLE
#ifdef CONFIG_IDT_PROM_CONSOLE
  register_console(&prom_console_driver);
#endif

  setup_serial_port();
	/* set our arch type */

	mips_machgroup = MACH_GROUP_IDT;

	/*
	 * give all RAM to boot allocator,
	 * except where the kernel was loaded
	 */
	add_memory_region(0,
			  rc32438_res_ram.end - rc32438_res_ram.start,
			  BOOT_MEM_RAM);
#ifdef CONFIG_REMOTE_DEBUG
	if(strstr(arcs_cmdline, "kgdb=on")) {
		remote_debug = 1;
	}
#endif

	return 0;
}

void prom_free_prom_memory(void)
{
	printk("stubbed prom_free_prom_memory()\n");
}
