/**************************************************************************
 *
 *  BRIEF MODULE DESCRIPTION
 *     Reset EB438 board.
 *
 *  Copyright 2004 IDT Inc. (rischelp@idt.com)
 *         
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 **************************************************************************
 * P. Sadik (Pallathu.Sadik@idt.com)                  
 * July 28 03            
 **************************************************************************
 */

#include <linux/init.h>
#include <linux/mm.h>
#include <linux/sched.h>
#include <linux/irq.h>
#include <asm/bootinfo.h>
#include <asm/io.h>
#include <linux/ioport.h>
#include <asm/mipsregs.h>
#include <asm/pgtable.h>
#include <linux/mc146818rtc.h>	/* for rtc_ops, we fake the RTC */
#include <asm/reboot.h>
#include <asm/addrspace.h>     /* for KSEG1ADDR() */
#include <asm/rc32438/rc32438.h>
#include <asm/rc32438/pci.h>
#include <asm/rc32438/pciacacia.h>
#include <asm/rc32438/eth.h>

void idt_reset(void)
{
  set_c0_status((ST0_BEV | ST0_ERL));
  set_c0_config(CONF_CM_UNCACHED);
  flush_cache_all();
  write_c0_wired(0);
//  write_32bit_cp0_register(CP0_WIRED, 0);

  /* Errata item #13 */
	
  *((volatile u32 *)KSEG1ADDR(0x18080000)) = 0x0;
  *((volatile u32 *)KSEG1ADDR(0x18080018)) = 0x0;
  *((volatile u32 *)KSEG1ADDR(0x18080024)) = 0x0;
  *((volatile u32 *)KSEG1ADDR(0x18080030)) = 0x0;
  *((volatile u32 *)KSEG1ADDR(0x1808003c)) = 0x0;

#if 0
// Commneting this for now 
  /* Reset*/
  *((volatile u32 *)KSEG1ADDR(0x18008000)) = 0x80000001;
#endif
// Work around for Rebooting the PB32 board
	__asm__ __volatile__("jr\t%0"::"r"(0xbfc00000));

}
