/**************************************************************************
 *
 *  BRIEF MODULE DESCRIPTION
 *     Serial port initialisation.
 *
 *  Copyright 2004 IDT Inc. (rischelp@idt.com)
 *         
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 **************************************************************************
 * P. Sadik 
 *
 * Original form
 **************************************************************************
 * P. Sadik Oct 20, 2003
 *
 * Changed setup_serial_port from static to extern, so that prom.c can call
 * this function directly.
 **************************************************************************
 */

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/proc_fs.h>
#include <linux/sched.h>
#include <asm/uaccess.h>
#include <linux/string.h>

#include <linux/types.h>
#include <linux/serial.h>
#include <asm/serial.h>
#include <asm/io.h>
#include <asm/rc32438/rc32438.h>

extern unsigned int idt_cpu_freq;
extern int __init setup_serial_port(void)
{
  struct serial_struct serial_req;
  memset(&serial_req,0,sizeof(serial_req));
  serial_req.type = PORT_16550;
  serial_req.baud_base =  idt_cpu_freq / 16;
  serial_req.iomem_base = (unsigned char *) KSEG1ADDR(RC32438_UART0_BASE);
  serial_req.irq = RC32438_UART0_IRQ;
  serial_req.iomem_reg_shift = 2;
  serial_req.io_type= SERIAL_IO_MEM;
  serial_req.flags= STD_COM_FLAGS;
  serial_req.type= 3;

  if (early_serial_setup(&serial_req) < 0) {
    printk("early_serial_setup() for serial console port failed\n");
    return(-1);
  } 
  printk("Serial console port initialized\n");
  return(0);
}
