/**************************************************************************
 *
 *  BRIEF MODULE DESCRIPTION
 *     setup routines for IDT EB438 boards
 *
 *  Copyright 2004 IDT Inc. (rischelp@idt.com)
 *         
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 **************************************************************************
 * Copyright (C) 2000 by Lineo, Inc.
 * Written by Quinn Jensen (jensenq@lineo.com)
 * Ammended by Gray Girling (GGirling@uk.research.att.com)
 **************************************************************************
 */

#include <linux/init.h>
#include <linux/mm.h>
#include <linux/sched.h>
#include <linux/irq.h>
#include <asm/bootinfo.h>
#include <asm/io.h>
#include <linux/ioport.h>
#include <asm/mipsregs.h>
#include <asm/pgtable.h>
#include <linux/mc146818rtc.h>	/* for rtc_ops, we fake the RTC */
#include <asm/reboot.h>
#include <asm/addrspace.h>     /* for KSEG1ADDR() */
#include <asm/rc32438/rc32438.h>
#include <asm/rc32438/pci.h>
#include <asm/rc32438/pciacacia.h>

extern char * __init prom_getcmdline(void);

extern void (*board_time_init)(void);
extern void (*board_timer_setup)(struct irqaction *irq);
extern void rc32438_time_init(void);
extern void rc32438_timer_setup(struct irqaction *irq);
extern void idt_reset(void);
void idt_disp_str(char *s);
#ifdef CONFIG_PCI
extern void __init rc32438_pcibridge_init(void);
extern int  __init rc32438_pci_dma_init(void);
#endif
struct resource rc32438_res_pci_mem1;
struct resource rc32438_res_pci_mem2;
struct resource rc32438_res_pci_mem3;

#define PCI_MEM1_START PCI_ADDR_START
#define PCI_MEM1_END   PCI_ADDR_START + CPUTOPCI_MEM_WIN - 1
#define PCI_MEM2_START PCI_ADDR_START + CPUTOPCI_MEM_WIN 
#define PCI_MEM2_END   PCI_ADDR_START + ( 2* CPUTOPCI_MEM_WIN)  - 1
#define PCI_IO1_START   PCI_ADDR_START + (2 * CPUTOPCI_MEM_WIN) 
#define PCI_IO1_END     PCI_ADDR_START + (2* CPUTOPCI_MEM_WIN) + CPUTOPCI_IO_WIN -1
#define PCI_IO2_START   PCI_ADDR_START + (2 * CPUTOPCI_MEM_WIN) + CPUTOPCI_IO_WIN
#define PCI_IO2_END     PCI_ADDR_START + (2* CPUTOPCI_MEM_WIN) + (2 * CPUTOPCI_IO_WIN) -1


struct resource rc32438_res_pci_mem1 = {
	"PCI Mem1",
	0x50000000,
	0x5FFFFFFF,
	IORESOURCE_MEM,
	&rc32438_res_pci_mem1,
	NULL,
	&rc32438_res_pci_mem2
};
struct resource rc32438_res_pci_mem2 = {
	"PCI Mem2",
	0x60000000,
	0x6FFFFFFF,
	IORESOURCE_MEM,
	&rc32438_res_pci_mem1,
	NULL,
	NULL
};
struct resource rc32438_res_pci_mem3 = {
	"PCI Mem3",
	0x18C00000,
	0x18FFFFFF,
	IORESOURCE_MEM,
	&rc32438_res_pci_mem1,
	NULL,
	NULL
};


struct resource rc32438_res_pci_io1 = {
	"PCI I/O1",
	0x18800000,
	0x188FFFFF,
	IORESOURCE_IO
};

#define DIG_CLEAR ((volatile unsigned char *)0xAC000000)
#define DIG0 ((volatile unsigned char *)0xAC040003)
#define DIG1 ((volatile unsigned char *)0xAC040002)
#define DIG2 ((volatile unsigned char *)0xAC040001)
#define DIG3 ((volatile unsigned char *)0xAC040000)

void idt_disp_char(int i, char c)
{
	switch(i) {
		case 0: *DIG0 = c; break;
		case 1: *DIG1 = c; break;
		case 2: *DIG2 = c; break;
		case 3: *DIG3 = c; break;
		default: *DIG0 = '?'; break;
	}
}

void idt_disp_str(char *s)
{
	if(s == 0) {
		char c = *DIG_CLEAR;
	} else {
		int i;
		for(i = 0; i < 4; i++) {
			if(s[i]) idt_disp_char(i, s[i]);
		}
	}
}


static void idt_machine_restart(char *command)
{
	printk("idt_machine_restart: command=%s\n", command);

	idt_reset();
}

static void idt_machine_halt(void)
{
	printk("idt_machine_halt:  halted\n");
	for(;;) continue;
}

static void idt_machine_power_off(void)
{
	printk("idt_machine_power_off:  It is now safe to turn off the power\n");
	for(;;) continue;
}

void __init idt_setup(void)
{
	unsigned int pciCntlVal;

//	idt_disp_str("Unix");

	board_time_init = rc32438_time_init;

	board_timer_setup = rc32438_timer_setup;

	_machine_restart = idt_machine_restart;
	_machine_halt = idt_machine_halt;
	_machine_power_off = idt_machine_power_off;
	set_io_port_base(KSEG1);

	ioport_resource.start = rc32438_res_pci_io1.start;
	ioport_resource.end = rc32438_res_pci_io1.end;
	iomem_resource.start = rc32438_res_pci_mem1.start;
	iomem_resource.end = rc32438_res_pci_mem2.end;
        write_c0_wired(0);

//	write_32bit_cp0_register(CP0_WIRED, 0);
 /* Disable the IP bus error for PCI scaning */
	pciCntlVal=rc32438_pci->pcic;
	pciCntlVal &= 0xFFFFFF7;
	rc32438_pci->pcic = pciCntlVal;
#ifdef CONFIG_PCI
	rc32438_pcibridge_init();
	rc32438_pci_dma_init();
#endif

}

int page_is_ram(unsigned long pagenr)
{
	return 1;
}

const char *get_system_type(void)
{
	return "MIPS IDT32438";
}
