/**************************************************************************
 *
 *  BRIEF MODULE DESCRIPTION
 *     timer routines for IDT EB438 boards
 *
 *  Copyright 2004 IDT Inc. (rischelp@idt.com)
 *         
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 **************************************************************************
 * Carsten Langgaard, carstenl@mips.com
 * Copyright (C) 1999,2000 MIPS Technologies, Inc.  All rights reserved.
 **************************************************************************
 * P. Sadik Oct 10, 2003
 *
 * Started change log.
 * mips_counter_frequency is now calculated at run time, based on idt_cpu_freq.
 * Code cleanup
 **************************************************************************
 */

#include <linux/config.h>
#include <linux/init.h>
#include <linux/kernel_stat.h>
#include <linux/sched.h>
#include <linux/spinlock.h>
#include <linux/mc146818rtc.h>
#include <linux/irq.h>
#include <linux/timex.h>

#include <asm/mipsregs.h>
#include <asm/ptrace.h>
#include <asm/debug.h>
#include <asm/time.h>
#include <asm/rc32438/rc32438.h>
#include  <asm/rc32438/tim.h>
#include  <asm/rc32438/int.h>

static unsigned long r4k_offset; /* Amount to incr compare reg each time */
static unsigned long r4k_cur;    /* What counter should be at next timer irq */
extern void ll_timer_interrupt(int irq, struct pt_regs *regs);
//extern unsigned int mips_counter_frequency;
extern unsigned int mips_hpt_frequency;

extern unsigned int idt_cpu_freq;

#if defined(CONFIG_IDT_79EB438) && defined(CONFIG_MIPS_RTC)
extern void rtc_ds1553_init(void);
#endif

/* 
 * Figure out the r4k offset, the amount to increment the compare
 * register for each time tick. There is no RTC available.
 *
 * The RC32438 counts at half the CPU *core* speed.
 */
static unsigned long __init cal_r4koff(void)
{
	mips_hpt_frequency = idt_cpu_freq * IDT_CLOCK_MULT / 2;
	return (mips_hpt_frequency / HZ);
}

void __init rc32438_time_init(void)
{
        unsigned int est_freq, flags;

	__save_and_cli(flags);

	printk("calculating r4koff... ");
	r4k_offset = cal_r4koff();
	printk("%08lx(%d)\n", r4k_offset, (int) r4k_offset);

	est_freq = 2*r4k_offset*HZ;	
	est_freq += 5000;    /* round */
	est_freq -= est_freq%10000;
	printk("CPU frequency %d.%02d MHz\n", est_freq/1000000, 
	       (est_freq%1000000)*100/1000000);
	__restore_flags(flags);


#if defined(CONFIG_IDT_79EB438) && defined(CONFIG_MIPS_RTC)
	rtc_ds1553_init();
#endif
}


void __init rc32438_timer_setup(struct irqaction *irq)
{
        /* we are using the cpu counter for timer interrupts */
#if 0
	setup_irq(MIPS_CPU_TIMER_IRQ, irq);
        /* to generate the first timer interrupt */
	r4k_cur = (read_32bit_cp0_register(CP0_COUNT) + r4k_offset);
	write_32bit_cp0_register(CP0_COMPARE, r4k_cur);
	/* this is the last board dependent code */
#else
	setup_irq(8, irq);
	timer->tim[0].compare = r4k_offset;
 	timer->tim[0].ctc = 0x1;
#endif
	db_run(board_init_done_flag = 1);

}





